
float4x4 matWorldViewProjection; 
texture tex0; 
float time;
 

sampler2D ao = sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

void vs_plain(in float4 ipos : POSITION,
			  in float3 inorm : NORMAL,
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
};

float4 ps_texscroll(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(ao, tex+float2(time*.01f, 0.f));
};


float4 ps_tex(in float2 tex : TEXCOORD0) : COLOR0
{
	//return tex2D(ao, tex)*1.0f;
	
	float blur = 0.f;//(.5f+.5f*sin(time*.5))*8/700;
	
	float4 p =  tex2Dlod(ao, float4(tex.x, tex.y, 0.f, 0.f));
	
	for(int i=0; i<9 ; i++) 
		p += tex2Dlod(ao, float4(tex.x+blur*sin(i*60/6.28), tex.y+blur*cos(i*80/6.28), 0.f, i*.0));
		
	return p/10;
};

float4 ps_plain(in float2 tex : TEXCOORD0) : COLOR0
{
	return float4(0.f, 0.f, 0.f, 1.f); 
};

technique ao_diff
{
	pass plain 
	{
		vertexshader  = compile vs_2_0 vs_plain();
		pixelshader   = compile ps_2_0 ps_plain();
	}
	
	pass texure
	{
		vertexshader  = compile vs_3_0 vs_plain();
		pixelshader   = compile ps_3_0 ps_tex();
	}
	pass texurescoll
	{
		vertexshader  = compile vs_3_0 vs_plain();
		pixelshader   = compile ps_3_0 ps_texscroll();
	}
}

